/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.core.util.control.ISecurableTile;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class SecurityControlModule
implements ISecurable {
    protected ISecurableTile tile;
    protected BooleanSupplier enabled;
    protected GameProfile owner = SecurityHelper.DEFAULT_GAME_PROFILE;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;

    public SecurityControlModule(ISecurableTile tile) {
        this(tile, Constants.TRUE);
    }

    public SecurityControlModule(ISecurableTile tile, BooleanSupplier enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public SecurityControlModule setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.access = ISecurable.AccessMode.VALUES[buffer.readByte()];
        this.owner = SecurityHelper.DEFAULT_GAME_PROFILE;
        this.setOwner(new GameProfile(buffer.m_130259_(), buffer.m_130136_(1024)));
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeByte(this.access.ordinal());
        buffer.m_130077_(this.owner.getId());
        buffer.m_130070_(this.owner.getName());
    }

    public SecurityControlModule read(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("Security");
        if (subTag.m_128441_("SecUUID")) {
            String uuid = subTag.m_128461_("SecUUID");
            String name = subTag.m_128461_("SecName");
            this.owner = new GameProfile(UUID.fromString(uuid), name);
        } else {
            this.owner = SecurityHelper.DEFAULT_GAME_PROFILE;
        }
        this.access = this.isSecurable() ? ISecurable.AccessMode.VALUES[subTag.m_128445_("SecAccess")] : ISecurable.AccessMode.PUBLIC;
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.isSecurable()) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128359_("SecUUID", this.owner.getId().toString());
            subTag.m_128359_("SecName", this.owner.getName());
            subTag.m_128344_("SecAccess", (byte)this.access.ordinal());
            nbt.m_128365_("Security", (Tag)subTag);
        }
        return nbt;
    }

    @Override
    public boolean isSecurable() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setAccess(ISecurable.AccessMode access) {
        ISecurable.AccessMode curAccess = this.access;
        this.access = access;
        if (Utils.isClientWorld(this.tile.world())) {
            SecurityControlPacket.sendToServer(this.tile);
            this.access = curAccess;
        } else {
            this.tile.onControlUpdate();
        }
    }

    @Override
    public boolean setOwner(GameProfile profile) {
        if (!this.isSecurable()) {
            return false;
        }
        if (SecurityHelper.isDefaultProfile(this.owner) && !SecurityHelper.isDefaultProfile(profile)) {
            this.owner = profile;
            if (Utils.isServerWorld(this.tile.world())) {
                this.tile.onControlUpdate();
            }
            return true;
        }
        return false;
    }
}

